{   Anhang A3, Listing zum Programm GAUSS
    Lineare Algebra - GAUSSscher Algorithmus - Computergesttzte Begleitung

 ** Programm zur Lsung auch unterbestimmter linearer Gleichungssyteme    **
 ** in Turbo Pascal 5                 Joachim Geldmacher/ H. J. Kayser    **}

{$N+,E+}                             {Emulation des numerischen Coprozessors}

PROGRAM GAUSSscher_Algorithmus;
  Uses  Crt, DOS, Ut_4_91;             {Ut_4/91: Unit mit Utilities MBU 4/91}
  CONST max      = 9;    {maximale Dimension der Matrix; darf nicht gendert}
        Ret      = #13;{werden, wenn die Datei GAUSS.Dat benutzt werden soll}
        Esc      = #27;
  TYPE  Matrix   = ARRAY[0..max,0..max+1] OF extended; {Koeffizienten-Matrix}
        Vektor   = ARRAY[1..max] OF extended;                        {Vektor}
        Dat_LGS  = RECORD Anz:Byte; Name:String[32]; LGS:Matrix END;
        Sammlung = FILE OF Dat_LGS;        {Dat_LGS = LGS in Datei GAUSS.Dat}
  VAR   a,b,v    : Matrix;
        x        : Vektor;
        Datei    : Sammlung;                     {Aufgabensammlung GAUSS.Dat}
        n        : Integer;
        AusG     : Text;
        Geraet   : Char;
        Schluss, auf_Drucker, Einzelschritt, Error : Boolean;

PROCEDURE zeig_LGS(F:Matrix;n:Integer);                       {aktuelles LGS}
  VAR i,j : Integer;
BEGIN
  IF n>1
    THEN BEGIN
           clrscr;gotoxy(7,2); write('Das lineare Gleichungssystem lautet:');
           FOR i:=1 TO n DO BEGIN gotoxy(i*7+5,4); write('x',i:1) END;
           gotoxy((n+1)*7+5,4); write('b');
           FOR i:=1 TO n DO BEGIN gotoxy(7,i+5); write(i:1) END;
           FOR i:=1 TO n DO
             FOR j:=1 TO n+1 DO
               BEGIN gotoxy(j*7+2,i+5); write(F[i,j]:6:2) END
         END
    ELSE melde('Bitte zuerst eine Matrix eingeben !')
END;

PROCEDURE speichere_Matrix(a:Matrix;n:Integer;VAR Dat:Sammlung);
  VAR Satz : Dat_LGS;
      Bez  : String;
      i    : Integer;
BEGIN
  IF n<2 THEN melde('Bitte zuerst eine Matrix eingeben ! ')
         ELSE BEGIN
                zeig_LGS(a,n);
                window(1,25,79,25); inv; clreol;
                write(' LGS speichern -> Bezeichnung: ');
                gotoxy(35,1); FOR i:=1 TO 32 DO write('');
                gotoxy(35,1); readln(Bez);delete(Bez,32,length(Bez));
                IF Bez='' THEN exit;
                WITH Satz DO BEGIN Anz:=n; Name:=Bez; LGS:=a END;
                assign(Dat,'GAUSS.DAT'); reset(Dat);
                seek(Dat,filesize(Dat));write(Dat,Satz);
                close(Dat); clrscr
              END
END;

PROCEDURE lade_Matrix(VAR a:Matrix;VAR n:Integer; VAR Dat:Sammlung);
  VAR Satz : Dat_LGS;
      Nr   : Integer;
BEGIN
  {$I-} reset(Dat);{$I+}
  IF IOResult <> 0 THEN exit
    ELSE BEGIN
           clrscr;
           write('Liste der gespeicherten Aufgaben':45);
           WHILE NOT eof(Dat) DO
             BEGIN
               read(Dat,Satz);
               write(#10#13,filepos(Dat):10,' ':3,Satz.Name);
               IF eof(Dat) OR (filepos(Dat) MOD 20=0) THEN
                 BEGIN
                   frage('Welche Nummer ? (0 --> weiter, -1 --> Men) ',
                          Nr,-1,filesize(Dat));
                   IF Nr = -1 THEN BEGIN clrscr; exit END ELSE
                     IF Nr > 0 THEN
                       BEGIN
                         clrscr;
                         seek(Dat,Nr-1); read(Dat,Satz);
                         a:=Satz.LGS; n:=Satz.Anz;
                         zeig_LGS(a,n);
                         seek(Dat,filesize(Dat))
                       END ELSE clrscr
                 END
             END
         END; close(Dat)
END;

PROCEDURE loesche_Aufgabe_in(VAR Dat:Sammlung);
  VAR h    : Dat_LGS;
      HDat : Sammlung;
      Nr   : Integer;
      exist: Boolean;
BEGIN
  {$I-} reset(Dat);{$I+}IF IOResult <> 0 THEN exit ELSE
  BEGIN
    frage('Welche Aufgabe lschen ? (0-keine) ',Nr,0,filesize(Dat));
    IF Nr = 0
      THEN melde('Zurck zum Men ! ')
      ELSE BEGIN
             assign(HDat,'GAUSS.TMP'); rewrite(HDat); reset(Dat);
             exist:=Nr<=filesize(Dat);
             IF exist THEN REPEAT
                             read(Dat,h);
                             IF filepos(Dat) <> Nr THEN write(HDat,h);
                           UNTIL eof(Dat)
                      ELSE melde('Aufgabe existiert nicht !');
             close(Dat); close(HDat);
             IF exist THEN BEGIN erase(Dat); rename(HDat,'GAUSS.DAT') END
                      ELSE erase(HDat)
           END
  END
END;

PROCEDURE lies_Matrix(VAR a:Matrix; VAR n: Integer);   {Neueingabe eines LGS}
  VAR s   : String;
      i,j : Integer;
BEGIN
  clrscr;
  FOR i:=1 TO max DO FOR j:=1 TO max+1 DO a[i,j]:=0;n:=-1;
  frage('Wie viele Variable hat Ihr System ? (0 oder 1 --> Men) ',n,0,max);
  IF n < 2 THEN exit;
  clreol; nrm; window(2,4,79,24);
  Zeig_LGS(a,n);
  gotoxy(7,2); writeln('Geben Sie nun die (erweiterte) Matrix ein : ');
  window(10,9,7*(n+2)+2,n+8); textbackground(7); clrscr; window(2,4,79,24);
  FOR i:=1 TO n DO
    FOR j:=1 TO n+1 DO readReal(j*7+2,i+5,6,2,a[i,j]); ton(200)
END;

PROCEDURE korrigiere(VAR a:Matrix;n:Integer);     {Korrektur bei Fehleingabe}
  VAR cd,i,k       : Integer;
      Zeile,Spalte : String;
      ok           : Boolean;
BEGIN
  IF n>1 THEN
    REPEAT
      frage(' nderung in Zeile (0 fr keine nderung) -->  ',i,0,n);
      IF i=0 THEN exit;
      frage(' Spalte  -->  ',k,1,n+1);
      window(2,4,79,24); nrm;
      readReal(k*7+2,i+5,6,2,a[i,k]);
      zeig_LGS(a,n);
      frag('Matrix richtig ? (j,n) ',ok)
    UNTIL ok
  ELSE melde('Bitte zuerst eine Matrix eingeben !')
END;

PROCEDURE halt_an;
  VAR Taste:Char;
BEGIN
  IF Geraet = 'B' THEN
    BEGIN
      textattr:=158;
      gotoxy(50,wherey);write(' Weiter mit < RETURN > !! ');
      textattr:=31; REPEAT Taste:=readkey UNTIL Taste IN [Ret,Esc];
      IF Taste = Esc THEN exit;
      gotoxy(50,wherey); clreol
    END;
  writeln(AusG)
END;

PROCEDURE zeig_Matrix(a:Matrix; n:Integer; VAR AG:Text);
VAR i, k : Integer;                                      { A usgabe G eraet }
BEGIN
  FOR i := 1 TO n DO
    BEGIN
      FOR k := 1 TO n DO write(AG,a[i,k]:7:2);
      writeln(AG,'  ',a[i,n+1]:7:2)
    END
END;

PROCEDURE do_Gauss_Alg(VAR a:Matrix; n:Integer);     {GAUSSscher Algorithmus}
  VAR i,j,Zeil,z : Integer;
      Mult       : Real;
      h          : Matrix;
      Schrittzaehler : Integer;
BEGIN
  IF auf_Drucker THEN
    BEGIN
      writeln(AusG,#27+#77,#27+#108+#5);
      writeln(AusG,'    Lsung linearer Gleichungssysteme');
      writeln(AusG,'    mittels GAUSS-Algorithmus''');writeln(AusG)
    END; clrscr;
  IF Einzelschritt THEN BEGIN zeig_Matrix(a,n,AusG);halt_an END;      {Start}
  Schrittzaehler:=0;
  FOR Zeil:=1 TO n-1 DO
    BEGIN
      inc(Schrittzaehler);
      IF Einzelschritt
        THEN writeln(AusG,'   Erzeugung von Nullen in der ',Zeil,'. ',
                          'Spalte unterhalb der Hauptdiagonalen:');
      z:=Zeil;                                              {Arbeitszeile z }
      WHILE a[Zeil,Zeil]=0 DO                                   {Pivot = 0 ?}
        BEGIN
          inc(z);                                             {nchste Zeile}
          IF z>n THEN exit;                       {Abbruch bei letzter Zeile}
          h[1]:=a[Zeil]; a[Zeil]:=a[z]; a[z]:=h[1];
          IF Einzelschritt THEN               {tausch Zeil-te und z-te Zeile}
            BEGIN
              writeln(AusG);
              writeln(AusG,#7,Zeil:4,'. und ',z,'. Zeile tauschen ! ',
                                                           'Neue Matrix:');
              zeig_Matrix(a,n,AusG);halt_an
            END
        END;
      FOR i:=Zeil+1 TO n DO
        BEGIN
          Mult:=-a[i,Zeil]/a[Zeil,Zeil];               {Multiplikator bilden}
          a[i,Zeil]:=0;                                {Pivotspalte 0 setzen}
          FOR j:=Zeil+1 TO n+1 DO a[i,j]:=a[i,j]+Mult*a[Zeil,j];
            IF Einzelschritt THEN IF Mult <> 0
              THEN BEGIN
                     writeln(AusG,'   Addition des (',Mult:6:2,')-fachen ',
                                  'der ',Zeil,'. zur ',i,'. Zeile:');
                     zeig_Matrix(a,n,AusG);
                     IF Schrittzaehler=n-1 THEN ton(300);
                     halt_an
                   END                                   {Zwischenergebnisse}
        END
    END
END;

FUNCTION Dimension(a:Matrix;n:Integer):Integer;  {Dimension der Lsungsmenge}
  VAR i,j,u,v :Integer;                          {Dimension = n - Rang(a)   }
BEGIN
  Dimension:=0; v:=0;                                        {genau 1 Lsung}
  IF a[n,n]=0 THEN
    BEGIN
      FOR i:=n DOWNTO 2 DO
        BEGIN
          u:=0;
          FOR j:=i TO n+1 DO IF a[i,j]=0 THEN inc(u);    {u zhlt die Nullen}
          IF u=n-i+2 THEN inc(v)                     {v zhlt die Nullzeilen}
        END;
      IF v>0 THEN Dimension:=v ELSE Dimension:=-1              {v-dim Lsung}
    END                                                    {-1: keine Lsung}
END;

PROCEDURE ermittle_Loesung(a:Matrix;n:Integer; VAR x:Vektor;VAR v: Matrix);
  VAR linkeSeite  : Extended;
      dim,i,j,k,q : Integer;
BEGIN
  error:=false;
  dim:=Dimension(a,n);
  IF dim =0 THEN                                      {eindeutige Lsbarkeit}
    BEGIN
      x[n]:=a[n,n+1]/a[n,n];
      FOR i:=n-1 DOWNTO 1 DO
        BEGIN
          linkeSeite:=0;
          IF a[i,i]=0 THEN BEGIN melde('Fehler ! '); error:=true; exit END;
          FOR j:=i+1 TO n DO linkeSeite:=linkeSeite+a[i,j]*x[j];
          x[i]:=(a[i,n+1]-linkeSeite)/a[i,i]
        END
    END;
  IF dim>0 THEN
    BEGIN
      q:=0;
      FOR i:=n DOWNTO n-dim+1 DO
        BEGIN
          FOR j:=0 TO dim DO v[j,i]:=0;
          inc(q); v[q,i]:=1              {Initialisierung des Lsungsvektors}
        END;
      FOR i:=n-dim DOWNTO 1 DO
        BEGIN
          IF a[i,i]=0 THEN BEGIN melde('Fehler ! '); error:=true; exit END;
          FOR k:=0 TO dim DO
            BEGIN
              v[k,i]:=0;
              FOR j:=i+1 TO n DO v[k,i]:=v[k,i]-a[i,j]*v[k,j]/a[i,i]
            END;
          v[0,i]:=v[0,i]+a[i,n+1]/a[i,i]
        END
    END
END;

PROCEDURE gib_Loesung_aus(a:Matrix; n:Integer; x:Vektor; v:Matrix);
  CONST z = #26;                                               {Vektorpfeil}
  VAR   dim,i,j,k,l,m : Integer;
BEGIN
  IF (auf_Drucker AND NOT Einzelschritt) THEN
    BEGIN
      zeig_Matrix(b,n,AusG);writeln(AusG);
      zeig_Matrix(a,n,AusG);writeln(AusG)
    END;
  dim:=Dimension(a,n);
  gotoxy(1,7+n);
  IF dim=-1 THEN BEGIN writeln(AusG,' ':6,'Das LGS ist unlsbar.'); exit END;
  IF dim=0 THEN
    BEGIN                                                    {genau 1 Lsung}
      If not Einzelschritt then
      frage('Wie viele Nachkommastellen (0..18) ? ',l,0,18)
      else l:=6;
      gotoxy(1,7+n); writeln(AusG,' ':6,'Der Lsungsvektor ist: ');
      IF (n <= 5) THEN writeln(AusG);
      m:=n DIV 2 + 1;
                          writeln(AusG,'           ', ' ':5+l,    ' ');
      FOR i:= 1 TO m-2 DO writeln(AusG,'           ',x[i]:5+l:l,  ' ');
      IF Geraet='B' THEN writeln(AusG,' ':6,z,'    ',x[m-1]:5+l:l,' ')
                     ELSE writeln(AusG,' ':7, '    ',x[m-1]:5+l:l,' ');
                          writeln(AusG,'      x =  ',x[m]:5+l:l,  ' ');
      FOR i:= m+1 TO n DO writeln(AusG,'           ',x[i]:5+l:l,  ' ');
                          write  (AusG,'           ', ' ':5+l,    ' ')
    END;
  IF dim > 0 THEN
    IF dim > 3
      THEN BEGIN
             write(AusG,'Das LGS ist ',dim,'-fach unterbestimmt. ');
             writeln(AusG,'Vereinfachte Darstellung der Lsungsvektoren');
             FOR i:=1 TO n DO
               BEGIN
                 FOR k:=0 TO dim DO write(AusG,v[k,i]:7:2);
                 writeln(AusG)
               END
           END
      ELSE BEGIN
             writeln(AusG,'      Die Lsungsmenge besteht aus allen ',
                         'Vektoren der Form: ');
             IF (n <= 5) THEN writeln(AusG);
             write(AusG,' ':6);
             FOR i:=0 TO dim DO write(AusG,'':5 ,' ':8,  '  ');
             writeln(AusG);
             IF Geraet ='B' THEN write(AusG,' ':6,z,'   ')
                            ELSE write(AusG,' ':10);
             FOR i:=0 TO dim DO write(AusG,'',v[i,1]:8:3,'      ');
             writeln(AusG);
             IF n>2 THEN
               BEGIN
                 write(AusG,'      x = ');
                 FOR i:=0 TO dim-1 DO
                 write(AusG,  '',v[i,2]:8:3,  ' ',' + ',chr(114+i),' ');
                 writeln(AusG,'',v[dim,2]:8:3,' ');
                 FOR i:=3 TO n DO
                 BEGIN
                   write(AusG,' ':10);
                   FOR j:=0 TO dim DO
                   write(AusG,'',v[j,i]:8:3,'      ');
                   writeln(AusG)
                 END
               END;
             IF n = 2
               THEN BEGIN
                      write(AusG,'      x = ');
                      write(AusG,  '',v[0,2]:8:3,'  + r ');
                      writeln(AusG,'',v[1,2]:8:3,' ')
                    END;
             write(AusG,' ':10);
             FOR j:=0 TO dim DO write(AusG,'',   ' ':8  ,'      ')
           END;
  IF Geraet = 'D' THEN writeln(AusG)
END;

PROCEDURE Menu;                                                 {Auswahlmen}
  VAR Wahl:Char;
BEGIN
  window(1,25,80,25); inv; clreol;
  write('F1-Hilf F2-Sav F3-Lad F4-reMov F5-Neu F6-Korr F7-Zeig F8-Rech ');
  write('F9-DR-');IF auf_Drucker THEN write('AN ') ELSE write('AUS');
  write(' ESC:End');
  REPEAT
    Wahl:=upcase(readkey)
  UNTIL Wahl IN ['0'..'9',#0,'H','S','L','M','N','K','Z','R','D','E',Esc];
  IF Wahl=#0 THEN REPEAT Wahl:=readkey UNTIL Wahl IN [#59..#67,Esc];
  nrm; window(2,4,79,24);
  CASE Wahl OF
    #59,'H': Hilfe;
    #60,'S': speichere_Matrix(b,n,Datei);
    #61,'L': BEGIN lade_Matrix(a,n,Datei); b:=a END;
    #62,'M': loesche_Aufgabe_in(Datei);
    #63,'N': BEGIN lies_Matrix(a,n); b:=a;  END;
    #64,'K': korrigiere(b,n);
    #65,'Z': zeig_LGS(b,n);
    #66,'R': IF n>1 THEN
               BEGIN
                 frag('Einzelschritt-Modus ? (j/n) ',Einzelschritt);
                 a:=b; do_Gauss_Alg(a,n);
                 ermittle_Loesung(a,n,x,v);
                 clrscr; zeig_LGS(b,n);
                 if error then write(' --> Fehler!')
                          else gib_Loesung_aus(a,n,x,v)
               END ELSE melde('Bitte zuerst eine Matrix eingeben !');
    #67,'D': BEGIN
               auf_Drucker:=NOT auf_Drucker;
               waehle_Drucker_Monitor(auf_Drucker,Geraet,AusG)
             END;
    Esc,'E': frag('Programm wirklich beenden ? (j/n) ',Schluss)
  END
END;

BEGIN                                                         {Hauptprogramm}
  clrscr;
  Num_Lock_setzen;
  zeig_Vorspann;
  assign(Datei,'GAUSS.Dat');{$I-} reset(Datei);{$I+}
  IF IOResult<>0 THEN rewrite(Datei);close(Datei);
  Schluss:=false; auf_Drucker:=false; n:=0;
  assignCrt(AusG);Geraet:='B';rewrite(AusG);      {Gert: 'B' fr Bildschirm}
  REPEAT                                                 {'D' fr Drucker   }
    Menu
  UNTIL Schluss;
  window(1,1,80,25); textattr:= 7; clrscr
END.
