{$N+,E+}                             {Emulation des numerischen Coprozessors}
Unit Ut_4_91;

interface
  Uses Crt, DOS;

  PROCEDURE cursor_off;
  PROCEDURE cursor_on;
  PROCEDURE Num_Lock_setzen;
  PROCEDURE inv;
  PROCEDURE nrm;
  PROCEDURE zeig_Vorspann;
  PROCEDURE melde(s:String);
  PROCEDURE frag(s: String;VAR ok:Boolean);
  PROCEDURE frage(s:String;VAR Zahl:Integer;min,max:Integer);
  PROCEDURE waehle_Drucker_Monitor(VAR auf_Dr:Boolean;VAR Geraet:Char;
                                 VAR AG:Text);
  PROCEDURE Hilfe;
  PROCEDURE readReal(x,y,v,n:Byte; VAR r:Extended);  {Zahleingabe, Real}
  PROCEDURE Ton(Dauer:Integer);

implementation

PROCEDURE cursor_off;
  VAR alta, altc : Byte;
      x,y  : Integer;
      regs : Registers;
BEGIN
  x:=-1; y:=-1;
  WITH regs DO
    BEGIN
      alta:=ax; altc:=cx;
      cx:=x shl 8; cx := cx OR y; Ax:=1 shl 8;
      INTR($10,regs)
    END
END;

PROCEDURE cursor_on;
  VAR alta, altc : Byte;
      regs : Registers;
BEGIN
  WITH regs DO
    BEGIN
      ax:=alta; cx:=altc;
      INTR($10,regs)
    END
END;

PROCEDURE Num_Lock_setzen;
CONST Num_Lock = 32;
VAR   adresse  : BYTE ABSOLUTE $0000:$0417;
BEGIN adresse:=adresse OR Num_Lock; END;

PROCEDURE inv;                                                {invers}
BEGIN textattr:={64}112 END;

PROCEDURE nrm;                                                {normal}
BEGIN textattr:=31{15}; END;

PROCEDURE zeig_Vorspann;
  VAR i,k : Integer;
BEGIN nrm; clrscr;
  write('');    FOR k:=2 TO 79 DO write('');  write('');
  write('');inv;write('GAUSS 2.0',
                       'Lineare Algebra - GAUSSscher Algorithmus':50,
                       ' MBU-Software':19);nrm;write('');
  write('');    FOR k:=2 TO 79 DO write('');  write('');
  FOR i:=4 TO 24 DO BEGIN
                      gotoxy( 1,i);write('');
                      gotoxy(80,i);write('')
                    END
END;

PROCEDURE melde(s:String);
BEGIN
  window(1,25,79,25); inv; clreol; write(#7,s:(40+length(s) DIV 2));
  delay(1500);clreol; nrm; window(2,4,79,24)
END;

PROCEDURE frag(s: String;VAR ok:Boolean);                  {Antwort ohne RET}
  VAR Antwort : Char;
BEGIN
  window(1,25,79,25); inv; clreol; write(s:(40+length(s) DIV 2));
  REPEAT Antwort:=upcase(readkey) UNTIL Antwort IN ['J','N'];
  IF Antwort ='J' THEN ok:=true ELSE ok:=false;
  window(1,25,79,25); clrscr; nrm; window(2,4,79,24)
END;

PROCEDURE frage(s:String;VAR Zahl:Integer;min,max:Integer);{Antwort mit RET}
  VAR Zahlstr:String;
      cd     :Integer;
BEGIN
  REPEAT
    window(1,25,79,25); inv; clreol; write(s:(40+length(s) DIV 2));
    readln(Zahlstr);val(Zahlstr,Zahl,cd);
    IF (cd<>0) OR (Zahl<min) OR (Zahl >max) THEN write(#7)
  UNTIL (cd=0) AND (Zahl >= min) AND (Zahl <= max);
  clreol; nrm; window(2,4,79,24)
END;

PROCEDURE waehle_Drucker_Monitor(VAR auf_Dr:Boolean;VAR Geraet:Char;
                                 VAR AG:Text);
  VAR Taste          : Char;
      Register       : Registers;
      Drucker_bereit : Boolean;
BEGIN
  IF auf_Dr
    THEN BEGIN
           Register.AH:=$02;Register.DX:=$00;Intr($17,Register);
           Drucker_bereit:=((Register.AH AND $90)=$90);
           IF Drucker_bereit
             THEN BEGIN assign(AG,'PRN');Geraet:='D' END
             ELSE BEGIN
                    melde('Drucker nicht bereit ! ');auf_Dr:=false;
                    assignCrt(AG);Geraet:='B'
                  END;
         END
    ELSE BEGIN assignCrt(AG);Geraet:='B' END;
  rewrite(AG)
END;

PROCEDURE Hilfe;                                            {Hilfebildschirm}
BEGIN
 clrscr;
 writeln(' GAUSS - Algorithmus');
 writeln(' zur Lsung linearer Gleichungssysteme bis Dimension 9.');
 writeln(' von Joachim Geldmacher, Kasseler Str. 6, 3544 Freienhagen, Tel: 05634/1719');
 writeln;
 writeln(' F1- Dieser Hilfebildschirm');
 writeln(' F2- Speichern des aktuellen LGS (Bezeichnung bis 32 Stellen)');
 writeln(' F3- Laden einer gespeicherten Aufgabe');
 writeln(' F4- Lschen einer fehlerhaften oder unntzen Aufgabe');
 writeln(' F5- Neueingabe eines LGS mit abgesicherter Zahleneingabe');
 writeln(' F6- Nachtrgliche Korrekturmglichkeit der Matrix');
 writeln(' F7- Anzeige der aktuellen Matrix');
 writeln(' F8- Lsung des LGS, Ausgabe auf Bildschirm oder Drucker');
 writeln(' F9- Umschalter: Drucker AN/ Drucker AUS');
 writeln(' ESC- Programmende');writeln;
 writeln(' Jeden Menpunkt erreicht man ber Funktionstasten oder Buchstaben.');
 writeln(' Die Eingabe erfolgt bei Zeichen ohne, bei Zahlen mit <RET>.');
 writeln(' Die Rechengenauigkeit betrgt 20 Stellen.');
 writeln(' Es kann zwischen Einzelschrittverfahren und direkter Lsungsbe-');
 writeln(' rechnung gewhlt werden.')
END;

PROCEDURE readReal(x,y,v,n:Byte; VAR r:Extended);  {Zahleingabe, Real}
  VAR s    : String[18];
      i,cd : Integer;
BEGIN
  s:='';
  REPEAT
    gotoxy(x,y); inv; FOR i:=1 TO v DO write(' ');
    gotoxy(x,y); readln(s);
    WHILE pos(' ',s)>0 DO delete(s,pos(' ',s),1); {fhrende Leerzeichen}
    IF pos(',',s)>0 THEN s[pos(',',s)]:='.';      {"," in "." umwandeln}
    IF s[1]='.' THEN insert('0',s,1);             {fhrender Punkt OK  }
    val(s,r,cd);
    IF cd<>0 THEN write(#7)
  UNTIL cd=0;
  gotoxy(x,y); write(r:v:n); nrm;
END;

PROCEDURE Ton(Dauer:Integer);
BEGIN nosound;sound(440);delay(Dauer);nosound END;


END.




